/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	ConstrainSeparationPointToPoint.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CConstraints.h"
#include "CApplication.h"


HRESULT ConstrainSeparationPointToPoint(IPoint *point1, IPoint *point2)
{

	//	Creates a PLLinearDim constraint between the two given points

	START_METHOD("ConstrainSeparationPointToPoint")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IPPLinearDim *ppLinearDim = NULL;
	status = (GetCLASS(PPLinearDim))->CreatePPLinearDim(point1, point2, &ppLinearDim);
	CHECK_RETURN_STATUS(status)

	IConstraint *pConstraint = NULL;

	status = activeWorkplane->CreateConstraint(CAST(IGeomConstraint,ppLinearDim), &pConstraint);
	CHECK_RETURN_STATUS(status)

	END_METHOD("ConstrainSeparationPointToPoint")
}
